function Tm = tau_tr(im, Rdus, ShowRslt)
%--------------------------------------------------------------------------
%   Vessel Turtusity Measurement 
%   This function gets a binary image of vessels as input and returns the
%   pointwise curvature using the metric t_tr described in the paper
%   
%   
%--------------------------------------------------------------------------
% Input:
%   im: Input Binary image
%   Rdus: ROI Radius
%          
% Output:
%   Local Turtusity 
%   If ShowRslt is set to 1, local tortuosity using k_tr is shown as well.
%--------------------------------------------------------------------------
% Author: H.R. Pourreza 3/3/2013
%--------------------------------------------------------------------------
global Brdr Msk MskArea;
Rm=2*Rdus+1;
Mrkr=logical(zeros(Rm,Rm)); Mrkr(Rdus+1,Rdus+1)=1;
SE=strel('disk', Rdus);
Msk=imdilate(Mrkr,SE);
MskArea=sum(Msk(:));
SE=strel('disk', 1);
%Brdr=Msk-imerode(Msk,SE);
Brdr=zeros(Rm,Rm); Brdr(1,:)=1;Brdr(Rm,:)=1;Brdr(:,1)=1;Brdr(:,Rm)=1;

[R C]=size(im);
Bm = BifurcationFun1(im, 2, 0);
ThinVes = bwmorph(im,'thin',Inf);
ThinVes=ThinVes&logical(1-Bm);
Tm=zeros(R,C);
for r=(Rdus+1):R-Rdus
	for c=(Rdus+1):C-Rdus
		if ThinVes(r,c)==1
            IM = imreconstruct(Mrkr,ThinVes((r-Rdus):(r+Rdus),(c-Rdus):(c+Rdus)),8);
			Tm(r,c)=k_tr(IM);
		end
	end
end

if ShowRslt==1
	figure; imshow(mat2gray(Tm));
    colormap('jet');
end

%%--------------------------------
% Curvature calculation with k_tr
%%--------------------------------

function Tur = k_tr(im)
global Brdr;
Tur=0;
BPs=im.*Brdr;
[L,BP] = bwlabel(BPs,8);
if BP==2
    IntrSec=(L==1);
    Teta1=IntrSecAngl(IntrSec);
    IntrSec=(L==2);
    Teta2=IntrSecAngl(IntrSec);
    DTeta=abs(Teta1-Teta2);
    if DTeta>pi
        DTeta=2*pi-DTeta;
    end
    Teta=(pi-DTeta)/2;
    S=sin(Teta);
    
    Tur=abs(2*S/(1-S^2));
    
end

%%----------------------------------------------
% Disk and function crossover angle calculation 
%%----------------------------------------------

function Angl = IntrSecAngl(im)
    [R C]=size(im);
    Cntr=fix(R/2)+1;
    r0=0;c0=0;
    for r=1:R
        for c=1:C
            r0=r0+r*im(r,c);
            c0=c0+c*im(r,c);
        end
    end
    A=sum(im(:));
    r0=Cntr-r0/A;
    c0=c0/A-Cntr;
    Angl=cart2pol(c0,r0);
    if Angl<0
        Angl=Angl+2*pi;
    end
