function Tm = tau_b(im, Rdus, ShowRslt)
%--------------------------------------------------------------------------
%   Vessel Turtusity Measurement 
%   This function gets a binary image of vessels as input and returns the
%   tortuosity using the metric t_b described in the paper
%   
%   
%--------------------------------------------------------------------------
% Input:
%   im: Input Binary image
%   Rdus: ROI Radius
%          
% Output:
%   Local Turtusity 
%   If ShowRslt is set to 1, local tortuosity using k_b is shown as well.
%--------------------------------------------------------------------------
% Author: H.R. Pourreza 3/3/2013
%--------------------------------------------------------------------------
global Brdr Msk MskArea;
Rm=2*Rdus+1;
Mrkr=logical(zeros(Rm,Rm)); Mrkr(Rdus+1,Rdus+1)=1;
SE=strel('disk', Rdus);
Msk=imdilate(Mrkr,SE);
MskArea=sum(Msk(:));
SE=strel('disk', 1);
Brdr=zeros(Rm,Rm); Brdr(1,:)=1;Brdr(Rm,:)=1;Brdr(:,1)=1;Brdr(:,Rm)=1;

[R C]=size(im);
Bm = BifurcationFun1(im, 2, 0);
ThinVes = bwmorph(im,'thin',Inf);
ThinVes=ThinVes&logical(1-Bm);
Tm=zeros(R,C);
for r=(Rdus+1):R-Rdus
	for c=(Rdus+1):C-Rdus
		if ThinVes(r,c)==1
            IM = imreconstruct(Mrkr,ThinVes((r-Rdus):(r+Rdus),(c-Rdus):(c+Rdus)),8);
			Tm(r,c)=k_b(IM);
		end
	end
end

if ShowRslt==1
	figure; imshow(mat2gray(Tm));
    colormap('jet');
end

%%--------------------------------
% Curvature calculation with k_b
%%--------------------------------

function Tur = k_b(im) 
global Brdr Msk MskArea;
Tur=0;
BPs=im.*Brdr;
[L,BP] = bwlabel(BPs,8);
if BP==2
    [L,BP] = bwlabel((1-im),4);
    L=L.*Msk;
    L1=(L==1);
    L2=(L==2);
    T1=sum(L1(:));
    T2=sum(L2(:));
    Tm=min(T1,T2);
    TM=max(T1,T2);
    Tur=TM;
end







