function Im=Vessel_Detection(f)
%--------------------------------------------------------------------------
%   Vessel Detection Algorithm 
%   This function gets an  image of retina as input and returns the
%   vessel map as described in the paper: 
%   "On curvature based automatic grading of retinal blood vessel tortuossity"
%   
%   
%--------------------------------------------------------------------------
% Input:
%   im: Input Binary image
%   
%          
% Output:
%   Vessel map
%   Masked image
%   Edges of the vessel map
%   Gray image
%   An image of ensemble retina and detected vessel map
%   If ShowRslt is set to 1, local tortuosity for each metric is shown as well.
%--------------------------------------------------------------------------
% Author: H.R. Pourreza 3/3/2013
%--------------------------------------------------------------------------
warning off
global BlkMsk TetaStp;

%Parameters
	n=13;								%######### Subimage Size
	stp=3;								%######### Overlap Control 
	TetaStp = 2;						%########### Teta Steps in Rad. Trans.
	LinVldThr = 3.3;					%######### Line Validation
%End Parameters

% Circular Mask
BlkMsk = ones(n,n);
nh = fix(n/2)+1;
rad2 = nh^2;
for r = 1:n
	for c = 1:n
		if (r-nh)^2+(c-nh)^2 > rad2
			BlkMsk(r,c) = 0;
		end
	end
end
% End Circular Mask



	
	[R,C,D]=size(f);

	msk=zeros(R, C, 'uint8');
	vesselWidth=zeros(R, C, n, 'uint8');
	for r=1:fix(n/stp):R-n+1
		for c=1:fix(n/stp):C-n+1
			fl=f(r:r+n-1,c:c+n-1,:);
			[mx LineStrt LineEnd LineAngle LineVld]=LocRadFun1(fl);
			if LineVld>(LinVldThr/n)
				ml=zeros(n,n); mz=zeros(n,n);
				ml(:,LineStrt:LineEnd)=1;
				ml=[mz ml mz; mz ml mz; mz ml mz];
				ml=imrotate(ml,LineAngle,'crop');
				mskl=uint8(ml(n+1:2*n,n+1:2*n));
				f2=fl(:,:,2);	f2=f2.*mskl;		t1=mean(f2(f2~=0));
				f2=fl(:,:,2);	f2=f2.*(1-mskl);	t2=mean(f2(f2~=0));
				f2=fl(:,:,2);	f2=uint8(im2bw(im2double(f2), (t1+t2)/2/255));
				mskl=mskl.*(1-f2);
				msk(r:r+n-1,c:c+n-1)=msk(r:r+n-1,c:c+n-1)|mskl;
			end
		end
	end

		
	g1=255-f(:,:,2);
	imwrite(g1, strcat('gray .png'));
	%figure(2); imshow(g1);

	%figure(3); imshow(msk*255);
	imwrite(msk*255, strcat('mask.png'));
	msk=imclose(msk,strel('disk', 2));
		%	figure(4); imshow(msk*255);
		imwrite(msk*255, strcat('modmask.png'));
	Im=msk*255;
	em=edge(msk);	em=1-em;
	imwrite(em, strcat('edge.png'));
	%figure(5); imshow(em);
	
	%f(:,:,1)=f(:,:,1).*em;
	f(:,:,1)=f(:,:,1).*uint8(em);	f(:,:,3)=f(:,:,3).*uint8(em);
	%figure(6); imshow(f);
	imwrite(f, strcat('result.png'));


end