%--------------------------------------------------------------------------
%   Vessel Turtusity Measurement 
%   This function gets an image of retinal vessels as input and returns the
%   tortuosity using the metrics  described in the paper 
%   "On curvature based automatic grading of retinal blood vessel tortuossity"
%   
%   
%--------------------------------------------------------------------------
% Input:
%   Im: Input image
%   DiskDiam: Radius of the template disk
%          
% Output:
%   Global tortuosity 
%   If ShowRslt is set to 1, local tortuosity for each metric is shown as well.
%--------------------------------------------------------------------------
% Author: H.R. Pourreza 3/3/2013
%--------------------------------------------------------------------------
close all
clear all
clc 

DiskDiam=5; % Diameter of the template disk
ShowRslt=1;

Im=imread('F:\Masoud\Projects\Curvature\New folder (2)\ROP Data Set\Image\Image1.jpg'); 
f=Vessel_Detection(Im);

T_b = tau_b(f, DiskDiam, ShowRslt);
Tortuosity_b=sum(sum(T_b))
        
T_cp = tau_cp(f, DiskDiam, ShowRslt);
Tortuosity_cp=sum(sum(T_cp))

T_tr = tau_tr(f, DiskDiam, ShowRslt);
Tortuosity_tr=sum(sum(T_tr))

