function Bm = BifurcationFun1(im, Rdus, ShowRslt)
%--------------------------------------------------------------------------
%   Bifurcation and Cross-over Detection
%   This function gets a binary image of vessels as input and returns a
%   mask as bifurcation and cross-over locations
%--------------------------------------------------------------------------
% Input:
%   im: Input Binary image
%   Rdus: ROI Radius
%          
% Output:
%   Bm: bifurcation and cross-over mask.
%--------------------------------------------------------------------------
% Author: H.R. Pourreza 1/4/1392
%--------------------------------------------------------------------------
global Bordr;
Rm=2*Rdus+1;
Bordr=zeros(Rm,Rm);
Bordr(1,:)=1;Bordr(Rm,:)=1;Bordr(:,1)=1;Bordr(:,Rm)=1;
Mrkr=logical(zeros(Rm,Rm)); Mrkr(Rdus+1,Rdus+1)=1;
[R C]=size(im);
ThinVes = bwmorph(im,'thin',Inf);
Bm=zeros(R,C);
for r=(Rdus+1):R-Rdus
	for c=(Rdus+1):C-Rdus
		if ThinVes(r,c)==1
            IM = imreconstruct(Mrkr,ThinVes((r-Rdus):(r+Rdus),(c-Rdus):(c+Rdus)),8);
            Bm(r,c)=LocChk(IM);
		end
	end
end

if ShowRslt==1
    m=1-Bm;
    Rslt=zeros(R,C,3);
    Rslt(:,:,3)=ThinVes.*m;Rslt(:,:,2)=ThinVes.*m;Rslt(:,:,1)=ThinVes;
    imtool(Rslt);
end



function Bf = LocChk(im)
global Bordr;
Bf=0;
BPs=Bordr.*im;
[L,BP] = bwlabel(BPs,8);
if BP>2
    Bf=1;
end
